#include <iostream>
#include <algorithm>
#include <fstream>

#include <vector>
#include <set>
#include <map>
#include <deque>

using namespace std;

using ll = long long;
using vl = vector<long long>;
using vvl = vector<vector<long long>>;
using pll = pair<long long, long long>;
using vpll = vector<pair<long long, long long>>;
using mll = map<long long, long long>;
using sl = set<long long>;

#define be(v) v.begin(), v.end()
#define for_up(i, bg, en) for(ll i = bg; i < en; i++)
#define for_down(i, bg, en) for(ll i = en - 1; i >= bg; i--)
#define for_auto(elem, N) for(auto elem : M)
#define print(a) cout << a
#define print_(a) cout << a << ' '
#define printn(a) cout << a << '\n'

struct segment_tree{
    ll length, height;
    vvl tree;
    vl values;

    segment_tree(ll n, vl& a){
        length = 1;
        height = 1;
        while (length < n){
            length *= 2;
            height++;
        }
        
        values = vl(length);
        for (ll i = 0; i < n; i++){
            values[i] = a[i];
        }

        tree = vvl(height, vl{});
        ll local_length = length;
        tree[0] = vl(length);
        for (ll i = 0; i < length; i++){
            tree[0][i] = i;
        }
        for (ll i = 1; i < height; i++){
            local_length /= 2;
            tree[i] = vl(local_length);
            for (ll j = 0; j < local_length; j++){
                tree[i][j] = join(i, j);
            }
        }
    }

    ll join(ll i, ll j){
        if (values[tree[i - 1][j * 2]] < values[tree[i - 1][j * 2 + 1]]){
            return tree[i - 1][j * 2];
        }
        else{
            return tree[i - 1][j * 2 + 1];
        }
    }

    ll assert(ll left_test, ll right_test, ll level, ll pos, ll left_block, ll right_block){
        if (left_test <= left_block && right_block <= right_test){
            return tree[level][pos];
        }
        if (right_block < left_test || right_test < left_block){
            return -1;
        }
        
        ll middle_block = (left_block + right_block) / 2;
        ll left_res = assert(left_test, right_test, level - 1, pos * 2, left_block, middle_block);
        ll right_res = assert(left_test, right_test, level - 1, pos * 2 + 1, middle_block + 1, right_block);
        if (left_res == -1){
            return right_res;
        }
        if (right_res == -1){
            return left_res;
        }
        if (values[left_res] < values[right_res]){
            return left_res;
        }
        else{
            return right_res;
        }
    }

    ll find_min(ll l, ll r){
        return assert(l, r, height - 1, 0, 0, length - 1);
    }
};


int main(){
    ll n, k;
    cin >> n >> k;
    string s;
    cin >> s;
    vl pref_summs(n);
    pref_summs[0] = s[0] == '(' ? 1 : -1;
    for_up(i, 1, n){
        pref_summs[i] = pref_summs[i - 1];
        pref_summs[i] += (s[i] == '(' ? 1 : -1);
    }

    segment_tree my_tree(n, pref_summs);
    for (ll k_ = 0; k_ < k; k_++){
        ll l, r;
        cin >> l >> r;
        l--;
        r--;
        ll pos = my_tree.find_min(l, r);
        ll delta = 0;
        if (l > 0){
            delta = pref_summs[l - 1];
        }

        ll minim = pref_summs[pos] - delta;
        ll last = pref_summs[r] - delta;
        if (minim >= 0){
            cout << last << '\n';
            continue;
        }
        if (minim < 0 && pos == r){
            cout << -minim << '\n';
            continue;
        }
        if (minim < 0){
            ll ans1 = -minim + (last - minim);
            ll ans2 = (pos - l + 1) + abs(last);
            cout << min(ans1, ans2) << '\n';
            continue;
        }
    }

    return 0;
}

